% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwig.R
\name{get_names}
\alias{get_names}
\title{Get HWI/HWIG names}
\usage{
get_names(DT, by)
}
\arguments{
\item{DT}{input group membership data, in individual/group format}

\item{by}{column(s) to split calculation by. e.g.: year}
}
\value{
names corresponding to values of by for each of the returned list of
  matrices in \link[hwig]{calc_hwi} and \link[hwig]{calc_hwig}.
}
\description{
Helper function, to return names of each matrix
}
\examples{
# Load data.table
library(data.table)

# Load example data
DT <- fread(system.file("extdata", "DT.csv", package = "hwig"))

# Calculate HWI
hwi <- calc_hwi(DT, 'id', 'group', 'yr')

# Calculate HWIG
hwig <- calc_hwig(hwi)

# Set names
nms <- get_names(DT, 'yr')
names(hwig) <- nms
}
\seealso{
\link[hwig]{calc_hwi} \link[hwig]{calc_hwig}
}
