% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenPareto.R
\name{GenPareto}
\alias{GenPareto}
\alias{dgpd}
\alias{mgpd}
\alias{pgpd}
\alias{qgpd}
\alias{rgpd}
\title{The Generalized Pareto Distribution}
\usage{
dgpd(x, mu = 0, sigma = 1, xi = 1, log = F)

mgpd(x, mu = 0, sigma = 1, xi = 1, log = F)

pgpd(q, mu = 0, sigma = 1, xi = 1, lower.tail = T)

qgpd(p, mu = 0, sigma = 1, xi = 1, lower.tail = T)

rgpd(n, mu = 0, sigma = 1, xi = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{location parameter.}

\item{sigma}{(non-negative) scale parameter.}

\item{xi}{shape parameter.}

\item{log}{logical; if \code{TRUE}, probabilities p are given 
as log(p).}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are 
\eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{numeric predictor matrix.}

\item{n}{number of random values to return.}
}
\value{
\code{dgpd} gives the continuous density, \code{pgpd} gives the distribution 
function, \code{qgpd} gives the quantile function, and \code{rgpd} 
generates random deviates. 

\code{mgpd} gives a probability mass function for a discretized version of GPD.
}
\description{
Density, distribution function, quantile function and random 
generation for the Generalized Pareto distribution with parameters
\code{mu}, \code{sigma}, and \code{xi}.
}
\details{
The generalized pareto distribution has density
\deqn{f(x) = \frac{\sigma^{\frac{1}{\xi}}}{(\sigma + \xi(x-\mu))^{\frac{1}{\xi}+1}}}{%
f(x) = sigma^(1/xi) / (sigma + xi*(x-mu))^(1/xi + 1)}
}
\examples{
dexp(1,rate=.5) #Exp(rate) equivalent to gpd with mu=0 AND xi=0, and sigma=1/rate.
dgpd(1,mu=0,sigma=2,xi=0) #cannot take xi=0.
dgpd(1,mu=0,sigma=2,xi=0.0000001) #but can get close.

##"mass" function of GPD
mgpd(8) == pgpd(8.5) - pgpd(7.5)
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
