% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_nodata.R
\name{h_nodata}
\alias{h_nodata}
\title{Replace values with NA conditionally or in a time interval}
\usage{
h_nodata(file, threshold = NA, test = "=", start = NA, end = NA)
}
\arguments{
\item{file}{File name to proceed}

\item{threshold}{Threshold value (default = NA)}

\item{test}{Test "=" (default);"<";"<=";">";">="}

\item{start}{Start date/time (included) of POSIXct class (default = NA)}

\item{end}{End date/time (excluded) of POSIXct class (default = NA)}
}
\description{
Replace values with NA conditionally or in a time interval
}
\details{
The function replace values with NA conditionally or introduce a gap for a given interval.

For the conditional option, the start parameter must be NA. A conditional test is applied on
the values (= ; > ; >= ; < ; <=) with a fixed threshold returning NA if the test is verified.

For the gap option, the threshold parameter must be NA. All the values of the records within the
interval start end are replaces by NA.

CAUTION ! At least one of both parameters threshold or start must not be NA.
NA.

The output file is named with a na_ prefix.
}
\examples{
\dontrun{

f <- h_nodata(f, threshold=10., test= "<=", start=NA)
}

}
\author{
P. Chevallier - Oct 2017-Jan 2019
}
