% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{formatted_tag_helper}
\alias{formatted_tag_helper}
\title{Helper function to generate HTML5 strings formatted with new lines and tabs}
\usage{
formatted_tag_helper(
  ...,
  attr = NULL,
  separate = FALSE,
  collapse = "",
  accepts_content = TRUE,
  tag
)
}
\arguments{
\item{...}{A string or strings or vector of content to pass to the tag.}

\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE. If TRUE, returns separate tags for each item of ...; if FALSE, returns one tag with the items of ... in the tag content.}

\item{collapse}{A string. If NULL, returns a vector the same length as ... instead of collapsing the tags into one string.}

\item{accepts_content}{TRUE/FALSE, if FALSE, does not include any content or end tag (ex: the input tag).}

\item{tag}{A string. The HTML5 tag to return.}
}
\value{
A HTML tag string.
}
\description{
Helper function to generate HTML5 strings formatted with new lines and tabs
}
\examples{
formatted_tag_helper(attr = list(class = 'test'), tag = 'a')
}
