% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagSNP.R
\name{tagSNP}
\alias{tagSNP}
\title{tagSNP}
\usage{
tagSNP(mat, threshold = 0.8)
}
\arguments{
\item{mat}{(p x p) correlation matrix}

\item{threshold}{lower value of correlation considered for grouping}
}
\value{
list (LEN number of groups) of lists (LEN 2); marker names correspond
  to column names of mat
\describe{
  \item{\code{snps}}{vector of marker IDs in group}
  \item{\code{tagsnp}}{representative marker suggested for this group}
}
}
\description{
Grouping of markers depending on correlation structure
}
\details{
Grouping of markers is based on the  correlation matrix. Apart from
  this, the strategy for grouping is similar to Carlson et al. (2004). A
  representative marker is suggested for each group.
}
\examples{
  ### 1: INPUT DATA
  data(testdata)
  ### 2: COVARIANCE/CORRELATION MATRIX
  corrmat <- CovMat(matLD, H.sire, 100, pos.chr, corr = TRUE)
  ### 3: TAGSNPS FROM CORRELATION MATRIX
  bin <- tagSNP(corrmat$R)
  bin <- tagSNP(corrmat$R, 0.5)
  as.numeric(unlist(rlist::list.select(bin, tagsnp)))
}
\references{
Carlson, Eberle, Rieder, Yi, Kruglyak & Nickerson (2004)
  Selecting a maximally informative set of single-nucleotide polymorphisms
  for association analyses using linkage disequilibrium. American Journal of
  Human Genetics 74:106-120.

  Wittenburg, Doschoris, Klosa (2021) Grouping of genomic markers in
  populations with family structure BMC Bioinformatics 22:79.
  \doi{10.1186/s12859-021-04010-0}
}
