% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_design.R
\name{plot_design}
\alias{plot_design}
\alias{plot_design_line}
\alias{plot_design_image}
\title{Plot design matrix}
\usage{
plot_design(design, method = c("lineplot", "imageplot"), ...)

plot_design_line(
  design,
  colors = "Set1",
  linetype = "solid",
  linewidth = 0.7,
  alpha = 0.8
)

plot_design_image(design)
}
\arguments{
\item{design}{The timepoints by fields design matrix or data.frame.}

\item{method}{\code{"lineplot"} (default) or \code{"imageplot"}.}

\item{...}{Additional arguments to \code{plot_design_line} or
\code{plot_design_image}.}

\item{colors}{The name of a ColorBrewer palette (see
RColorBrewer::brewer.pal.info and colorbrewer2.org), the name of a
viridisLite palette, or a character vector of colors. Default:
\code{"Set1"}.}

\item{linetype, linewidth, alpha}{Parameters for \code{ggplot2::geom_line}.
Defaults: \code{"solid"} linetype, \code{0.7} linewidth and \code{0.8}
alpha. \code{linetype} can also be a vector of options with length matching
the number of fields in \code{design}.}
}
\value{
A ggplot

A ggplot

A ggplot
}
\description{
Plot design matrix

Plot design with lineplot

Plot design with imageplot
}
