% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtTimeMatrix.R
\name{rtTimeMatrix}
\alias{rtTimeMatrix}
\title{Create model matrix for repeat transaction approach}
\usage{
rtTimeMatrix(rt_df)
}
\arguments{
\item{rt_df}{object of class `rtdata`: repeat transaction data.frame created by
rtCreateTrans()}
}
\value{
matrix to be used on the right hand side of a repeat sales regression model
}
\description{
Generates the array necessary to estimate a repeat transactions model
}
\section{Further Details}{

Time periods are calculated from the data provided.
}

\examples{

  # Load data
  data(ex_sales)

  # With a raw transaction data.frame
  rt_data <- rtCreateTrans(trans_df = ex_sales,
                           prop_id = 'pinx',
                           trans_id = 'sale_id',
                           price = 'sale_price',
                           periodicity = 'monthly',
                           date = 'sale_date')
 # Create Matrix
 rt_matrix <- rtTimeMatrix(rt_data)

}
