% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{anova.hopit}
\alias{anova.hopit}
\title{Likelihood Ratio Test Tables}
\usage{
\method{anova}{hopit}(object, ..., method = c("sequential",
"with.most.complex", 'with.least.complex'),
direction = c("decreasing", "increasing"))
}
\arguments{
\item{object}{an object containing the results returned by a \code{hopit}.}

\item{...}{an additional object(s) of the same type.}

\item{method}{the method of ordered model comparisons. Choose \code{"sequential"}
for 1-2, 2-3, 3-4, ... comparisons or
\code{"with.most.complex"} for 1-2, 1-3, 1-4, ... comparisons,
where 1 is the most complex model (the least complex for \code{"with.least.complex"}).}

\item{direction}{determine if the complexity of listed models is
\code{"increasing"} or \code{"decreasing"} (default).}
}
\value{
a vector or a matrix with the results of the test(s).
}
\description{
Perform the likelihood ratio test(s) for two or more \code{hopit} objects.
}
\examples{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------
\donttest{
# fitting two nested models
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# a model with an interaction between hypertension and high_cholesterol
model2 <- hopit(latent.formula = health ~ hypertension * high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# a likelihood ratio test
lrt1 <- anova(model1, model2)
lrt1

# print results in a shorter form
print(lrt1, short = TRUE)

# or equivalently
lrt.hopit(model2, model1)
}
# Example 2 ---------------------
\donttest{
# fitting additional nested models
model3 <- hopit(latent.formula = health ~ hypertension * high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese * diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

model4 <- hopit(latent.formula = health ~ hypertension * high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese * diabetes + other_diseases,
              thresh.formula = ~ sex * ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# sequential likelihood ratio tests
# model complexity increases so direction = "increasing"
anova(model1, model2, model3, model4,
      direction = "increasing", method = "sequential")

# likelihood ratio tests of the most complex model with the rest of the models
anova(model1, model2, model3, model4,
      direction = "increasing", method = "with.most.complex")

# likelihood ratio tests of the least complex model with the rest of the models
anova(model1, model2, model3, model4,
      direction = "increasing", method = "with.least.complex")
}
}
\seealso{
\code{\link{print.lrt.hopit}},
\code{\link{lrt.hopit}}, \code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
