% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_draft.R
\name{nba_draftcombineplayeranthro}
\alias{nba_draftcombineplayeranthro}
\title{\strong{Get NBA Stats API Draft Combine Player Anthropological Measurements}}
\usage{
nba_draftcombineplayeranthro(
  league_id = "00",
  season_year = most_recent_nba_season() - 1,
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{season_year}{season_year}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: Results

\strong{Results}\tabular{ll}{
   col_name \tab types \cr
   TEMP_PLAYER_ID \tab character \cr
   PLAYER_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   PLAYER_NAME \tab character \cr
   POSITION \tab character \cr
   HEIGHT_WO_SHOES \tab character \cr
   HEIGHT_WO_SHOES_FT_IN \tab character \cr
   HEIGHT_W_SHOES \tab character \cr
   HEIGHT_W_SHOES_FT_IN \tab character \cr
   WEIGHT \tab character \cr
   WINGSPAN \tab character \cr
   WINGSPAN_FT_IN \tab character \cr
   STANDING_REACH \tab character \cr
   STANDING_REACH_FT_IN \tab character \cr
   BODY_FAT_PCT \tab character \cr
   HAND_LENGTH \tab character \cr
   HAND_WIDTH \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Draft Combine Player Anthropological Measurements}

\strong{Get NBA Stats API Draft Combine Player Anthropological Measurements}
}
\details{
\href{https://www.nba.com/stats/draft/combine}{Draft Combine Player Anthro}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_draftcombineplayeranthro(season_year = most_recent_nba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Draft Functions: 
\code{\link{nba_draftboard}()},
\code{\link{nba_draftcombinedrillresults}()},
\code{\link{nba_draftcombinenonstationaryshooting}()},
\code{\link{nba_draftcombinespotshooting}()},
\code{\link{nba_draftcombinestats}()},
\code{\link{nba_drafthistory}()}
}
\author{
Saiem Gilani
}
\concept{NBA Draft Functions}
