% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_draft.R
\name{nba_draftcombinenonstationaryshooting}
\alias{nba_draftcombinenonstationaryshooting}
\title{\strong{Get NBA Stats API Draft Combine Non-Stationary Shooting}}
\usage{
nba_draftcombinenonstationaryshooting(
  league_id = "00",
  season_year = most_recent_nba_season() - 1,
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{season_year}{season_year}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: Results

\strong{Results}\tabular{ll}{
   col_name \tab types \cr
   TEMP_PLAYER_ID \tab character \cr
   PLAYER_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   PLAYER_NAME \tab character \cr
   POSITION \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_LEFT_MADE \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_LEFT_ATTEMPT \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_LEFT_PCT \tab character \cr
   OFF_DRIB_FIFTEEN_TOP_KEY_MADE \tab character \cr
   OFF_DRIB_FIFTEEN_TOP_KEY_ATTEMPT \tab character \cr
   OFF_DRIB_FIFTEEN_TOP_KEY_PCT \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_RIGHT_MADE \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_RIGHT_ATTEMPT \tab character \cr
   OFF_DRIB_FIFTEEN_BREAK_RIGHT_PCT \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_LEFT_MADE \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_LEFT_ATTEMPT \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_LEFT_PCT \tab character \cr
   OFF_DRIB_COLLEGE_TOP_KEY_MADE \tab character \cr
   OFF_DRIB_COLLEGE_TOP_KEY_ATTEMPT \tab character \cr
   OFF_DRIB_COLLEGE_TOP_KEY_PCT \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_RIGHT_MADE \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_RIGHT_ATTEMPT \tab character \cr
   OFF_DRIB_COLLEGE_BREAK_RIGHT_PCT \tab character \cr
   ON_MOVE_FIFTEEN_MADE \tab character \cr
   ON_MOVE_FIFTEEN_ATTEMPT \tab character \cr
   ON_MOVE_FIFTEEN_PCT \tab character \cr
   ON_MOVE_COLLEGE_MADE \tab character \cr
   ON_MOVE_COLLEGE_ATTEMPT \tab character \cr
   ON_MOVE_COLLEGE_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Draft Combine Non-Stationary Shooting}

\strong{Get NBA Stats API Draft Combine Non-Stationary Shooting}
}
\details{
\href{https://www.nba.com/stats/draft/combine-non-stationary}{Draft Combine Non-stationary Shooting}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_draftcombinenonstationaryshooting(season_year = most_recent_nba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Draft Functions: 
\code{\link{nba_draftboard}()},
\code{\link{nba_draftcombinedrillresults}()},
\code{\link{nba_draftcombineplayeranthro}()},
\code{\link{nba_draftcombinespotshooting}()},
\code{\link{nba_draftcombinestats}()},
\code{\link{nba_drafthistory}()}
}
\author{
Saiem Gilani
}
\concept{NBA Draft Functions}
