% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{group_equal}
\alias{group_equal}
\title{Group Equal Constraint}
\usage{
group_equal(vars)
}
\arguments{
\item{vars}{a vector specifying the indices or names of the covariates to which the constraint shall be applied.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Forces all covariates in the specified group to have the same coefficient.
}
\examples{
dat <- rhglm(100, c(1, 2, 3, 4, 5, 6))
constraints <- group_equal(vars = c("x1", "x3"))
hglm(y ~ ., constraints = constraints, data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
