% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_viz.R
\name{merge_carbontemp}
\alias{merge_carbontemp}
\title{Download and plot essential climate data}
\usage{
merge_carbontemp(carbon = get_carbon(), temp = get_temp())
}
\arguments{
\item{carbon}{Name of the tibble generated by \code{get_carbon}}

\item{temp}{Name of the tibble generated by \code{get_temp}}
}
\value{
Invisibly returns a tibble with merged datasets from \code{get_carbon} and \code{get_temp} functions.
}
\description{
Merge NOAA carbon and NASA temperature datasets on common dates.
}
\details{
\code{merge_carbontemp} invisibly returns a tibble with the merged data from from \code{get_carbon} and \code{get_temp} functions.
Tibble only includes data from dates when both datasets are available, essentially from 1960.
}
\examples{
\donttest{
# Create merged tibble

mergedcarbontemp <- merge_carbontemp() }


}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
