% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download and Extract data from online sources}
\usage{
download_data(dataset = NULL)
}
\arguments{
\item{dataset}{String containing the name of the dataset. Valid values
include:
- \code{"hk_accidents"}
- \code{"hk_casualties"}
- \code{"hk_vehicles"}}
}
\value{
A data frame is returned.
}
\description{
Download and extract data from preset online sources, specifying
the name of the dataset.
}
\details{
This supersedes the method for pulling \code{hk_accidents},
\code{hk_casualties}, and \code{hk_vehicles} due to the size of the data file. Refer
to \url{https://hong-kong-districts-info.github.io/hkdatasets/} to access the
data documentation for three datsets.
}
\examples{
\donttest{
# You can download and return a dataset with the following code:
download_data(dataset = "hk_vehicles")
}


}
