% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_plot_group.R
\name{hbl_plot_group}
\alias{hbl_plot_group}
\title{Plot the groups of the hierarchical model
and its benchmark models.}
\usage{
hbl_plot_group(
  borrow,
  pool,
  independent,
  outcome = c("response", "change", "diff")
)
}
\arguments{
\item{borrow}{A data frame returned by \code{\link[=hbl_summary]{hbl_summary()}}
for the hierarchical model.}

\item{pool}{A data frame returned by \code{\link[=hbl_summary]{hbl_summary()}}
for the pooled model.}

\item{independent}{A data frame returned by \code{\link[=hbl_summary]{hbl_summary()}}
for the independent model.}

\item{outcome}{Character of length 1, either \code{"response"}, \code{"change"},
or \code{"diff"}: the quantity to plot on the vertical axis.}
}
\value{
A \code{ggplot} object
}
\description{
Plot the groups against one another
for a hierarchical model.
and the independent and pooled benchmark models.
}
\examples{
if (!identical(Sys.getenv("HBL_TEST", unset = ""), "")) {
set.seed(0)
data <- hbl_sim_independent(
  n_study = 2,
  n_group = 2,
  n_patient = 5,
  n_rep = 3
)$data
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc_borrow <- hbl_mcmc_hierarchical(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc_pool <- hbl_mcmc_pool(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc_independent <- hbl_mcmc_independent(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
borrow <- hbl_summary(mcmc_borrow, data)
pool <- hbl_summary(mcmc_pool, data)
independent <- hbl_summary(mcmc_independent, data)
hbl_plot_group(
  borrow = borrow,
  pool = pool,
  independent = independent
)
}
}
\seealso{
Other plot: 
\code{\link{hbl_plot_borrow}()},
\code{\link{hbl_plot_tau}()}
}
\concept{plot}
