% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hint_main.R
\name{hint.dist.test}
\alias{hint.dist.test}
\title{hint.dist.test}
\usage{
hint.dist.test(d, n1, A1, n2, A2, q1 = 0, q2 = 0, alternative = "greater")
}
\arguments{
\item{d}{A positive integer specifying the observed distance to be tested.}

\item{n1}{An integer specifying the number of categories in the urns for the first distribution.}

\item{A1}{An integer vector specifying the number of balls drawn from urns for the first distribution.}

\item{n2}{An integer specifying the number of categories in the urns for the second distribution.}

\item{A2}{An integer vector specifying the number of balls drawn from the urns for the second distribution.}

\item{q1}{An integer specifying the number of categories with duplicates in the second urn of the first distribution. If 0 then the symmetric, singleton case is computed, otherwise the asymmetric, duplicates case is computed (see \code{\link{Hyperintersection}}).}

\item{q2}{An integer specifying the number of categories with duplicates in the second urn of the second distribution. If 0 then the symmetric, singleton case is computed, otherwise the asymmetric, duplicates case is computed (see \code{\link{Hyperintersection}}).}

\item{alternative}{A characer string specifying the hypothesis to be tested. Can be one of "greater", "less", or "two.sided".}
}
\value{
An object of class \code{hint.dist.test}, which is a list containing the following components:
\itemize{
\item \code{parameters} An integer vector giving the parameter values.
\item \code{p.value} A numerical value giving the p-value associated with the test.
\item \code{alternative} A character string naming the hypothesis that was tested.
}
}
\description{
Tests whether the absolute distance between two intersection sizes would be expected by chance, i.e. whether they fall into opposite tails of their respective Hypergeometric Intersection distributions.
}
\details{
The distribution of absolute distances between two hypergeometric intersection sizes is given by \deqn{P(X=d) = \sum_{\{v_{1},v_{2}\}_{i} \in D_{d}}^{|D_{d}|} P(v_{1_i}|n_{1},a_{1},b_{1},...)\cdot P(v_{2_i}|n_{2},a_{2},b_{2},...) }{P(X=d) = sum_{v1,v2} P(v1)*P(v2) } where \eqn{D_{d}}{D_d} is the set of pairs of intersection sizes, \eqn{\{v_{1},v_{2}\}}{(v_1,v_2)}, with absolute differences of size \eqn{d}{d}.
}
