% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_pair_apply.R
\name{probGreater}
\alias{probGreater}
\title{Creates function for one column with correct probability row1 is greater.}
\usage{
probGreater(criterion_col, output_column_name = "ProbGreater")
}
\arguments{
\item{criterion_col}{The integer index of the criterion in test_data.}

\item{output_column_name}{An optional string}
}
\value{
An object that implements createFunction.
  Users will generally not use this directly-- rowPairApply will.
}
\description{
Using rowPairApply, this can generate a column with
the correct probability that row 1 > row 2 for each row pair in 
the test_data.  It can do this using the criterion column passed in.
By default, the output column is called "ProbGreater," but you
can override the name with output_column_name.
}
\details{
Note this uses a very simplistic "probability" which only looks at
the current row pair.  It does not look at all sets of row pairs
with the same profile.
}
\seealso{
\code{\link{heuristicsProb}} is the wrapper to get the predicted probability
  that the first row in the row pair is greater, with output for each fitted
  heuristic passed to it.

\code{\link{rowPairApply}} which has examples of using this.
}
