% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarke_wright.R
\name{clarke_wright}
\alias{clarke_wright}
\title{Clarke-Wright algorithm, a Capacitated Vehicle Routing Problem solver}
\usage{
clarke_wright(
  demand,
  distances,
  vehicles,
  restrictions = data.frame(vehicle = integer(), site = integer())
)
}
\arguments{
\item{demand}{A numeric vector consisting of "demands" indexed by sites.
The \code{i}th entry refers to the demand of site \code{i} (and the length
of the vector equals the number of sites \code{N} with demands). The
units of demand values need to match the units of vehicle capacity values.
\code{NA} values are not allowed.}

\item{distances}{An object of class \code{dist}, created by \code{\link[stats:dist]{stats::dist()}}, with
\code{(N + 1)} locations describing the distances between individual
sites. The first index refers to the source site. The \code{(i+1)}th
index refers to site \code{i} (as defined by \code{demand}).}

\item{vehicles}{A \code{\link[=data.frame]{data.frame()}} describing available vehicle types and their respective
capacities. One row per vehicle type. The data frame is expected to have
two columns:
\itemize{
\item \code{n} - Number of available vehicles. This can be set to \code{NA} if the
number is "infinite" (i.e. effectively the maximal integer value
on your machine.).
It is recommended to keep at least one vehicle type as "infinite",
otherwise the solver might raise a run time error due to initially
not having enough vehicles available (even though the final
solution might satisfy the availability restrictions).
\item \code{caps} - The vehicle capacity in same units as \code{demand}.
}

The order of the \code{\link[=data.frame]{data.frame()}} is relevant and determines the prioritization
of vehicle assignments to runs (in case two or more vehicle types are
eligible for assignment the "first" vehicle is chosen). In a typical scenario
"more expensive" vehicles should be further down in the list (so the cheaper
one is chosen in case there is doubt). Since higher capacity vehicles
usually involve higher costs sorting the data frame by capacity is usually
a good rule of thumb.}

\item{restrictions}{An optional \code{\link[=data.frame]{data.frame()}} that allows to define vehicle type restrictions for
particular sites in the form of a blacklist.
The data frame is expected to have two columns:
\itemize{
\item \code{vehicle} - The vehicle type index.
\item \code{site} - The site index (i.e. the index of the \code{demand} vector)
}

Each row defines a restriction: vehicle type \code{vehicle} can not approach site
\code{site}. Defaults to an empty \code{\link[=data.frame]{data.frame()}}, i.e. no restrictions are enforced.}
}
\value{
Returns a "\code{heumilkr_solution}" object, a \code{\link[=data.frame]{data.frame()}} with one row per
site-run combination bestowed with additional attributes. Its columns
consist of:
\itemize{
\item \code{site} - The site index (i.e. the index of the \code{demand} vector) associated
to the run.
\item \code{run} - Identifies the run the site is assigned to.
\item \code{order}  - Integer values providing the visiting order within each run.
\item \code{vehicle} - The vehicle type index (as provided in \code{vehicles}) associated
to the run.
\item \code{load} - The actual load in units of \code{demand} on the particular run.
\item \code{distance} - The travel distance of the particular run.
}

Unless a site demand exceeds the vehicle capacities it is always assigned
to only a single run.
}
\description{
Finds a quasi-optimal solution to the Capacitated Vehicle Routing
Problem (CVRP). It is assumed that all demands will be satisfied by a
single source.
}
\details{
See the original paper,
Clarke, G. and Wright, J.R. (1964) \doi{10.1287/opre.12.4.568},
for a detailed explanation of the Clarke-Wright algorithm.
}
\examples{
demand <- c(3, 2, 4, 2)

positions <-
  data.frame(
    pos_x = c(0, 1, -1, 2, 3),
    pos_y = c(0, 1, 1, 2, 3)
  )

clarke_wright(
  demand,
  dist(positions),
  data.frame(n = NA_integer_, caps = 6)
)

}
