% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{allocq_c}
\alias{allocq_c}
\title{Allocation under maximum replication constraints}
\usage{
allocq_c(w, q, mr)
}
\arguments{
\item{w}{vector of weights}

\item{q}{scalar batch size}

\item{mr}{vector of maximum number of evaluation of each element}
}
\value{
allocation of integer number of runs depending on weights
}
\description{
Allocate replicates based on portfolio weights, with constraints on the number of possible designs
}
\details{
proceeds by dichotomy
}
\examples{
set.seed(42)
n <- 10
w <- runif(n)^4
w <- w/sum(w)
q <- 50
mr <- c(rep(2, round(n/2)), rep(q, round(n/2)))
al <- allocq(w = w, q = q)
al_c <- allocq_c(w = w, q = q, mr = mr)
par(mfrow = c(1,2))
plot(w, pch = 20)
plot(mr, ylim = c(0, q), type = "b", col = 4, lty = 3)
segments(x0 = (1:n)-0.02, x1 = (1:n) - 0.02, y0 = rep(0, n), y1 = al)
segments(x0 = (1:n)+0.02, x1 = (1:n) + 0.02, y0 = rep(0, n), y1 = al_c, col = "red")
legend("topleft", legend = c("without max rep", "with max rep"), col = c(1, 2), lty= 1)
par(mfrow = c(1,1))
print(sum(al))
print(sum(al_c))
}
