% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhance.R
\name{enhance}
\alias{enhance}
\title{Enhance penalty value}
\usage{
enhance(
  obj,
  par = rep(0, length(obj$n)),
  lower = rep(-20, length(par)),
  upper = rep(20, length(par)),
  method = "L-BFGS-B",
  control = list(),
  prepare = TRUE,
  loggcv = FALSE,
  ...
)
}
\arguments{
\item{obj}{A \code{prepared_*} object from a
\code{\link{prepare}} function.}

\item{par}{a vector of initial values for the parameters 
   for which optimal values are to be found. Names on the elements
   of this vector are preserved and used in the results data frame.}

\item{lower, upper}{Bounds on the variables for methods such as \code{"L-BFGS-B"} that can
   handle box (or bounds) constraints.}

\item{method}{The method to be used for optimization. The
default is \code{L-BFGS-B}, which allows for
constraints on the parameters to optimize.  See
\code{\link[optimx]{optimx}} for all available methods.}

\item{control}{A list of control parameters. See \sQuote{Details}.}

\item{prepare}{A logical value.  The default is \code{TRUE},
indicating that a \code{prepared_data} object should be
returned.  If \code{FALSE}, then the results of the
call to the \code{\link[optimx]{optimx}} function is
returned.}

\item{loggcv}{A logical value indicating whether the log
of the GCV statistic should be used.  Useful for very large
data sets.  Default is \code{TRUE}.}

\item{...}{Additional arguments to pass to to the
\code{\link[optimx]{optimx}} function.}
}
\value{
By default, a \code{prepared_data} object with
  the optimal \code{loglambda} values that minimize the
  GCV, along with an additional component,
  \code{results}, that contains the optimization results.
}
\description{
\code{enhance} enhances the sandwich smoother by choosing
the optimal penalty value that minimizes the GCV
statistic.    The \code{\link[optimx]{optimx}} function
is used to do the optimization.
}
\details{
Internally, the \code{\link{loglambda2gcv}} is  used as
the objective function for the
\code{\link[optimx]{optimx}} function. Many different
optimization methods are available.  The default is
\code{L-BFGS-B}, which allows for constraints on the
parameters to optimize.  Another excellent choice is the
\code{nlminb} algorithm, which also allows for parameter
constraints.
}
\examples{
# create b-splines
x1 = bspline(nbasis = 10)
x2 = bspline(nbasis = 12)

# observed data locations
evalarg1 = seq(0, 1, len = 60)
evalarg2 = seq(0, 1, len = 80)

# construct "true" data
mu = matrix(0, nrow = 60, ncol = 80)
for(i in seq_len(60)) {
   for(j in seq_len(80)) {
      mu[i, j] =  sin(2*pi*(evalarg1[i]-.5)^3)*cos(4*pi*evalarg2[j])
   }
}
# construct noisy data
data = mu + rnorm(60 * 80)

obj = prepare(data, list(evalarg1, evalarg2), list(x1, x2))
enhance(obj)
}
\author{
Joshua French
}
