% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrow3d.R
\name{arrow3d}
\alias{arrow3d}
\title{Draw a 3D Arrow in an RGL Scene}
\usage{
arrow3d(
  p0 = c(0, 0, 0),
  p1 = c(1, 1, 1),
  barblen,
  s = 0.05,
  theta = pi/6,
  n = 3,
  ...
)
}
\arguments{
\item{p0}{Initial point (tail of arrow)}

\item{p1}{Ending point (head of arrow)}

\item{barblen}{Length of each barb, in data units}

\item{s}{length of barb as fraction of line length (unless barblen is
specified)}

\item{theta}{opening angle of barbs}

\item{n}{number of barbs}

\item{\dots}{args passed to lines3d for line styling, e.g., \code{color},
\code{lwd}, etc. See \code{\link[rgl]{material3d}}.}
}
\value{
Returns (invisibly): integer ID of the line added to the scene %%
}
\description{
Draws a 3D arrow in an rgl scene with barbs at the arrow head
}
\examples{

arrow3d(c(0,0,0), c(2,2,2), barblen=.2, lwd=3, col="black")
arrow3d(c(0,0,0), c(-2,2,2), barblen=.2, lwd=3, col="red")

}
\seealso{
\code{\link[rgl]{lines3d}}, \code{\link[rgl]{segments3d}},
}
\author{
Barry Rowlingson, posted to R-help, 1/10/2010
}
\keyword{aplot}
