% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plot.R
\name{networkPlot}
\alias{networkPlot}
\title{Plot graph with the option of using different colors for connected components}
\usage{
networkPlot(
  df,
  title = "Network plot",
  rankCol = "rank",
  edgeScale = 2,
  nodeSize = 10,
  nodeTextSize = 2.3,
  palette = "Spectral",
  nodeColor = NULL,
  edgeColor = "black",
  ...
)
}
\arguments{
\item{df}{Data frame.}

\item{title}{Plot title.}

\item{rankCol}{Name of the rank column.}

\item{edgeScale}{Scaling factor used in generating
edge weights.}

\item{nodeSize}{Size of graph nodes.}

\item{nodeTextSize}{Size of text on graph nodes.}

\item{palette}{grDevices palette used for coloring nodes.
Ignored if nodeColor is not \code{NULL}.}

\item{nodeColor}{Color used for nodes. Default is \code{NULL}
(\code{palette} will instead be used).}

\item{edgeColor}{Color used for edges.}

\item{...}{Other arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{ggraph}.
}
\description{
This function plots the graph of the data frame and optionallt uses different
colors for nodes belonging to different connected components.
}
\examples{
df <- data.frame(gene1 = paste0('G', c(1, 2, 5, 6, 7, 17)),
gene2 = paste0('G', c(2, 5, 8, 11, 11, 11)),
rank = c(1, 1, 3, 3, 3, 3))
networkPlot(df)

}
