% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{isPointOnBoundary}
\alias{isPointOnBoundary}
\title{Check if a point is on a polygon boundary}
\usage{
isPointOnBoundary(xPoint, yPoint, boundary)
}
\arguments{
\item{xPoint}{x coordinate of point P.}

\item{yPoint}{y coordinate of point P.}

\item{boundary}{A data frame with four columns representing segments
comprising the boundary.}
}
\value{
Logical; whether the point is on the boundary.
}
\description{
This function checks if a point P is on a polygon boundary.
}
\examples{
pointsDF <- data.frame(x = c(1, 2, 4, 7, 10,
12, 13, 15, 16),
y = c(1, 1, 2, 3, 3, 2,
1, 2, 1))

hullIndices <- grDevices::chull(pointsDF[, 1], pointsDF[, 2])
hull <- convexHull(pointsDF, hullIndices)
hullSegments <- pointsToSegments(hull)

isPointOnBoundary(2, 3, hullSegments)

}
