% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_feature_list.R
\name{get_feature_list}
\alias{get_feature_list}
\title{Print all available Features}
\usage{
get_feature_list(base.url = NULL, queries = c(request = "GetCapabilities"))
}
\arguments{
\item{base.url}{WFS url, for example "https://kartta.hsy.fi/geoserver/wfs"}

\item{queries}{desired query for acquiring the list of features, default
is "request=GetCapabilities"}
}
\value{
data frame
}
\description{
Basically a neat wrapper for "request=GetCapabilities".
}
\details{
Lists all \verb{<FeatureType>} nodes.
}
\examples{
\dontrun{
dat <- get_feature_list(base.url = "https://kartta.hsy.fi/geoserver/wfs")
}

}
\seealso{
Use \code{\link[=get_feature]{get_feature()}} to download feature,
\code{\link[=select_feature]{select_feature()}} for menu-driven listing and downloading
}
\author{
Pyry Kantanen \href{mailto:pyry.kantanen@gmail.com}{pyry.kantanen@gmail.com}
}
