% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{apply_shift}
\alias{apply_shift}
\title{Apply a time shift to a survival distribution}
\usage{
apply_shift(dist, shift)
}
\arguments{
\item{dist}{A survival distribution.}

\item{shift}{A time shift to be applied.}
}
\value{
A \code{surv_shift} object.
}
\description{
Apply a time shift to a survival distribution
}
\details{
A positive shift moves the fit backwards in time.   That is,
a shift of 4 will cause time 5 to be evaluated as time 1, and so on.
If \code{shift == 0}, \code{dist} is returned unchanged.
}
\examples{

dist1 <- define_surv_dist(distribution = "gamma", rate = 0.25, shape = 3)
shift_dist <- apply_shift(dist1, 4)
compute_surv(dist1, 1:10)
compute_surv(shift_dist, 1:10)
}
