% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcovCL.heckmanGE.R
\name{vcovCL.heckmanGE}
\alias{vcovCL.heckmanGE}
\title{Variance-Covariance with Cluster Correction for Heckman Models}
\usage{
vcovCL.heckmanGE(
  x,
  cluster = NULL,
  type = NULL,
  sandwich = TRUE,
  fix = FALSE,
  ...
)
}
\arguments{
\item{x}{An object resulting from the estimation of a Heckman model using the \code{heckmanGE} method.}

\item{cluster}{A vector or factor identifying clusters in the data. If NULL, assumes no clustering.}

\item{type}{A character string specifying the type of cluster correction to be applied. It can be
\code{"HC0"}, \code{"HC1"}, \code{"HC2"}, or \code{"HC3"}.}

\item{sandwich}{A logical value. If TRUE, the function applies the sandwich estimator to the
variance-covariance matrix.}

\item{fix}{A logical value. If TRUE, corrects any negative eigenvalues in the variance-covariance matrix.}

\item{...}{Additional arguments that can be passed to internal methods.}
}
\value{
A corrected variance-covariance matrix.
}
\description{
The \code{vcovCL.heckmanGE} function computes the variance-covariance matrix of a Heckman model,
applying a cluster correction. This is useful for obtaining robust variance estimates, especially
when there is within-group dependence.
}
\details{
This function is a specialized implementation for obtaining a robust variance-covariance matrix
from Heckman models estimated with \code{heckmanGE}. It allows for cluster correction, which is particularly
important in contexts where observations within groups may not be independent.
}
\seealso{
\code{\link[=meatCL.heckmanGE]{meatCL.heckmanGE()}}, \code{\link[=sandwich.heckmanGE]{sandwich.heckmanGE()}}, \code{\link[=bread.heckmanGE]{bread.heckmanGE()}}
}
