% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proto_event3.R
\name{proto_event3}
\alias{proto_event3}
\title{Detect proto-events based on a chosen criterion (column).}
\usage{
proto_event3(p_series, criterion_column, minDuration, joinAcrossGaps, maxGap)
}
\arguments{
\item{p_series}{A data.table of the correct dimensions received
from \code{\link{detect_event3}} within which this runs.}

\item{criterion_column}{The column to use for the detection of events.}

\item{minDuration}{Minimum duration for acceptance of detected events.}

\item{joinAcrossGaps}{This logic gate tells this internal function if
it should connect events across the \code{maxGap} (see below). The
default it inherits is \code{TRUE}.}

\item{maxGap}{This is the number of rows (days) across which distinct
events will be combined into one event if \code{joinAcrossGaps = TRUE}.}
}
\value{
A dataframe that will be used within \code{\link{detect_event}},
or which can be returned by \code{\link{detect_event}} if the switch
'protoEvent' is specified as TRUE.
}
\description{
An internal function that detects the events according to the heatwave
definition, and joins across the gaps if desired. This is an update of
\code{\link{detect_event}} and is made entirely within data.table to
benefit from the speed improvements.
}
\author{
Albertus J. Smit, Robert W. Schlegel
}
\keyword{internal}
