% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_heart.R
\name{pulse_doublecheck}
\alias{pulse_doublecheck}
\title{(\verb{STEP 5}) Fix heart rate frequencies double the real value}
\usage{
pulse_doublecheck(heart_rates, flag = 0.9, correct = TRUE)
}
\arguments{
\item{heart_rates}{the output from \code{\link[=pulse_heart]{pulse_heart()}}}

\item{flag}{numerical, decimal from 0 to 1, defaults to \code{0.9}; values of \code{d_r} above this number will be flagged as instances where the algorithm resulted in double the real heart rate. Values above \code{1}are meaningless (zero data points will be flagged), and values below \code{~0.66} are too lax (many data points will be flagged when they shouldn't).}

\item{correct}{logical, defaults to \code{TRUE}; if \code{FALSE}, data points with \code{hz} values likely double the real value are flagged \strong{BUT NOT CORRECTED}. If \code{TRUE}, \code{hz} (as well as \code{data}, \code{n}, \code{sd} and \code{ci}) are corrected accordingly. Note that the correction is not reversible!}
}
\value{
A tibble similar to the one used as input, now augmented with two new columns: \code{d_r} and \code{d_f}. Values of \code{d_r} (ratio) close to \code{1} are indicative that the value for \code{hz} determined by the algorithm should be halved. If \code{correct} was set to \code{TRUE}, \code{d_f} flags data points where \code{hz} \strong{HAS BEEN HALVED}. If \code{correct} was set to \code{FALSE}, then \code{d_f} flags data points where \code{hz} \strong{SHOULD BE HALVED}.
}
\description{
\itemize{
\item \verb{step 1} -- \code{\link[=pulse_read]{pulse_read()}}
\item \verb{step 2} -- \code{\link[=pulse_split]{pulse_split()}}
\item \verb{step 3} -- \code{\link[=pulse_optimize]{pulse_optimize()}}
\item \verb{step 4} -- \code{\link[=pulse_heart]{pulse_heart()}}
\item \strong{\verb{-->>} step 5 -- \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} \verb{<<--}}
\item \verb{step 6} -- \code{\link[=pulse_choose_keep]{pulse_choose_keep()}}
}

Flag (and correct) data points where it is likely that the heart rate frequency computed corresponds to double the actual heart rate frequency due to the algorithm having identified two peaks per heart beat
}
\section{Heart beat frequency estimation}{

For many invertebrates, the circulatory system includes more than one contractile chamber, meaning that there are two consecutive movements that may or may not be detected by the PULSE system's IR sensors. Furthermore, when the sensor is attached to the shell of the animal, it remains at a fixed position even as the soft body tissues move below that. As a result, even if one takes explicit care to position the sensor in such a way that only one wave peak is detected for each heart beat cycle, at some point the animal may move and the sensor's field of view may come to encompass both contractile chambers. When that occurs, the shape of the signal detected will include two peaks per heart beat cycle, the relative sizes of which may vary considerably. To be clear, there's nothing wrong with such a signal. However, it creates a problem: the algorithm detects peaks, and therefore, if two peaks are detected for each heart beat, the resulting estimate for the heart beat frequency will show a value twice as much as the real value.
}

\section{Detection method}{

While it is often easy to discern if a PULSE data point has two peaks per heart beat upon visual inspection, to do so automatically is much harder. The strategy employed here relies on analyzing the intervals between consecutive peaks and looking for a regular alternation between longer and shorter intervals, as well as higher and lower peak signal values. If intervals are consistently shorter, then longer, then shorter again, we can assume that the distribution of interval times is bimodal, and that there are always two peaks more closer together separated by a longer interval - a classical two-peaks-per-heart-beat situation. For example, let's say 24 peaks are detected. We can compute the time span between each peak, which will correspond to 23 intervals (measured in seconds). Then, intervals can be classified as being longer or shorter than the preceding interval. Lastly, we divide the number of longer-than-previous intervals by the total number of intervals, deriving the ratio of switching intervals. Similarly, if peak signal values are consistently higher, then lower, then higher again, we can also assume that two different heart movements belonging to the same heartbeat are represented in the data, and a similar algorithm can be followed. The closer the ratio is to \code{1}, the more certain we are that we are facing a situation where the algorithm will result in a heart beat frequency twice the real value. Because the choice of a threshold to flag data points as needing to be halved or not is arbritary, both the flagging and the ratio are provided in the output, thus enabling a reassessment of the resulting classification.
}

\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:3]
pulse_data_split <- pulse_split(pulse_data_sub)
pulse_data_split <- pulse_optimize(pulse_data_split, multi = pulse_data$multi)
heart_rates <- pulse_heart(pulse_data_split)
## End prepare data ----

# Correct heartbeat frequency estimates
pulse_doublecheck(heart_rates)
}
\seealso{
\itemize{
\item \code{\link[=pulse_heart]{pulse_heart()}} generates the tibble that is used as input.
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_heart]{pulse_heart()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once, including the identification of possible heart rate doublings
}
}
