% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-hai-winsorized-truncate.R
\name{hai_winsorized_truncate_augment}
\alias{hai_winsorized_truncate_augment}
\title{Augment Function Winsorize Truncate}
\usage{
hai_winsorized_truncate_augment(.data, .value, .fraction, .names = "auto")
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.value}{This is passed \code{\link[rlang:enquo]{rlang::enquo()}} to capture the vectors you want
to augment.}

\item{.fraction}{A positive fractional between 0 and 0.5 that is passed to the
\code{stats::quantile} paramater of \code{probs}.}

\item{.names}{The default is "auto"}
}
\value{
An augmented tibble
}
\description{
Takes a numeric vector and will return a tibble with the winsorized values.
}
\details{
Takes a numeric vector and will return a winsorized vector of values that have
been truncated if they are less than or greater than some defined fraction of
a quantile. The intent of winsorization is to limit the effect of extreme values.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out <- 24
by_unit <- "month"
start_date <- as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a = rnorm(len_out),
  b = runif(len_out)
)

hai_winsorized_truncate_augment(data_tbl, a, .fraction = 0.05)

}
\seealso{
\url{https://en.wikipedia.org/wiki/Winsorizing}

Other Augment Function: 
\code{\link{hai_fourier_augment}()},
\code{\link{hai_fourier_discrete_augment}()},
\code{\link{hai_hyperbolic_augment}()},
\code{\link{hai_polynomial_augment}()},
\code{\link{hai_scale_zero_one_augment}()},
\code{\link{hai_scale_zscore_augment}()},
\code{\link{hai_winsorized_move_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
