% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmean-funcs.R
\name{hai_kmeans_tidy_tbl}
\alias{hai_kmeans_tidy_tbl}
\alias{kmeans_tidy_tbl}
\title{K-Means Object Tidy Functions}
\usage{
hai_kmeans_tidy_tbl(.kmeans_obj, .data, .tidy_type = "tidy")

kmeans_tidy_tbl(.kmeans_obj, .data, .tidy_type = "tidy")
}
\arguments{
\item{.kmeans_obj}{A \code{\link[stats:kmeans]{stats::kmeans()}} object}

\item{.data}{The user item tibble created from \code{\link[=hai_kmeans_user_item_tbl]{hai_kmeans_user_item_tbl()}}}

\item{.tidy_type}{"tidy","glance", or "augment"}
}
\value{
A tibble
}
\description{
K-Means tidy functions
}
\details{
Takes in a k-means object and its associated user item tibble and then
returns one of the items asked for. Either: \code{\link[broom:reexports]{broom::tidy()}}, \code{\link[broom:reexports]{broom::glance()}}
or \code{\link[broom:reexports]{broom::augment()}}. The function defaults to \code{\link[broom:reexports]{broom::tidy()}}.
}
\examples{
library(healthyR.data)
library(dplyr)
library(broom)

data_tbl <- healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  filter(payer_grouping != "Medicare B") \%>\%
  filter(payer_grouping != "?") \%>\%
  select(service_line, payer_grouping) \%>\%
  mutate(record = 1) \%>\%
  as_tibble()

uit_tbl <- hai_kmeans_user_item_tbl(
  .data = data_tbl,
  .row_input = service_line,
  .col_input = payer_grouping,
  .record_input = record
)

km_obj <- hai_kmeans_obj(uit_tbl)

hai_kmeans_tidy_tbl(
  .kmeans_obj = km_obj,
  .data = uit_tbl,
  .tidy_type = "augment"
)

hai_kmeans_tidy_tbl(
  .kmeans_obj = km_obj,
  .data = uit_tbl,
  .tidy_type = "glance"
)

hai_kmeans_tidy_tbl(
  .kmeans_obj = km_obj,
  .data = uit_tbl,
  .tidy_type = "tidy"
) \%>\%
  glimpse()

}
\seealso{
Other Kmeans: 
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
