% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5-functions.R
\name{h5TryOpen}
\alias{h5TryOpen}
\title{Automatically retry opening HDF5 file}
\usage{
h5TryOpen(
  filename,
  mode = c("a", "r", "r+", "w", "w-", "x"),
  timeout = getOption(x = "h5TryOpen.timeout", default = 0),
  interval = getOption(x = "h5TryOpen.interval", default = 0),
  ...
)
}
\arguments{
\item{filename}{An HDF5 file to open}

\item{mode}{How to open it: 
\itemize{
\item \code{a} creates a new file or opens an existing one for read/write. 
\item \code{r} opens an existing file for reading
\item \code{r+} opens an existing file for read/write. 
\item \code{w} creates a file, truncating any existing ones.
\item \code{w-} and \code{x} are synonyms, creating a file and failing if it 
already exists.
}}

\item{timeout}{Positive integer. The timeout for retrying.}

\item{interval}{Positive integer. The interval seconds of retrying.}

\item{...}{Arguments passed to \code{H5File$new()}}
}
\value{
When \code{file} is opened successfully, an \code{\link[hdf5r]{H5File}} will 
be returned. Otherwise, will keep retrying. When a timeout is reached, will 
raise an error and terminate the current R session.
}
\description{
Helper function to open an HDF5 file. When the opening fails, will retry it 
until reach a timeout.
}
\details{
\code{timeout} and \code{interval} must be positive. Otherwise no retrying, 
which is default setting.
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
h5fh <- h5TryOpen(file, mode = "r")
h5fh
h5fh$close_all()

}
\seealso{
\code{\link[hdf5r]{H5File}} for \code{mode}
}
