% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.mixturecure}
\alias{summary.mixturecure}
\title{Summarize a fitted mixture cure object}
\usage{
\method{summary}{mixturecure}(object, ...)
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs},
\code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.}

\item{...}{other arguments.}
}
\value{
prints the number of non-zero coefficients from the incidence and
latency portions of the fitted mixture cure model when using the minimum AIC
to select the final model. When fitting a model using \code{curegmifs} or
\code{cureem} the summary function additionally prints results associated
with the following model selection methods: the step and value that maximizes
the log-likelihood; the step and value that minimizes the AIC, modified AIC
(mAIC), corrected AIC (cAIC), BIC, modified BIC (mBIC), and extended BIC
(EBIC). This information can be used to guide the user in the selection of
a final model from the solution path.
}
\description{
\code{summary} method for a mixturecure object fit using \code{curegmifs},
\code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
summary(fit)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}},
\code{\link{coef.mixturecure}}, \code{\link{plot.mixturecure}},
\code{\link{predict.mixturecure}}
}
\keyword{methods}
