% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_npp_lognc.R
\name{glm.npp.lognc}
\alias{glm.npp.lognc}
\title{Estimate the logarithm of the normalizing constant for normalized power prior (NPP) for one data set}
\usage{
glm.npp.lognc(
  formula,
  family,
  histdata,
  a0,
  offset0 = NULL,
  beta.mean = NULL,
  beta.sd = NULL,
  disp.mean = NULL,
  disp.sd = NULL,
  bridge.args = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}.}

\item{histdata}{a \code{data.frame} giving the historical data.}

\item{a0}{the power prior parameter (a scalar between 0 and 1).}

\item{offset0}{vector whose dimension is equal to the rows of the historical data set giving an offset for the
historical data. Defaults to a vector of 0s.}

\item{beta.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the mean parameters for the normal initial prior on regression coefficients given the dispersion
parameter. If a scalar is provided, beta.mean will be a vector of repeated elements of the given
scalar. Defaults to a vector of 0s.}

\item{beta.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sd parameters for the initial prior on regression coefficients. The sd used is
\code{sqrt(dispersion) * beta.sd}. If a scalar is provided, same as for beta.mean. Defaults to
a vector of 10s.}

\item{disp.mean}{location parameter for the half-normal prior on dispersion parameter. Defaults to 0.}

\item{disp.sd}{scale parameter for the half-normal prior on dispersion parameter. Defaults to 10.}

\item{bridge.args}{a \code{list} giving arguments (other than samples, log_posterior, data, lb, ub) to pass
onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g. seed, refresh, init).}
}
\value{
The function returns a vector giving the value of a0, the estimated logarithm of the normalizing constant, the minimum
estimated bulk effective sample size of the MCMC sampling, and the maximum Rhat.
}
\description{
Uses Markov chain Monte Carlo (MCMC) and bridge sampling to estimate the logarithm of the normalizing
constant for the NPP for a fixed value of the power prior parameter \eqn{a_0 \in (0, 1)} for one data
set. The initial priors are independent normal priors on the regression coefficients and a half-normal
prior on the dispersion parameter (if applicable).
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg036)
  ## take subset for speed purposes
  actg036 = actg036[1:50, ]
  glm.npp.lognc(
    cd4 ~ treatment + age + race,
    family = poisson(), histdata = actg036, a0 = 0.5,
    chains = 1, iter_warmup = 500, iter_sampling = 5000
  )
}
}
\references{
Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
