#' AIDS Clinical Trial ACTG019
#'
#' A data set from the AIDS clinical trial ACTG019 (\url{https://clinicaltrials.gov/ct2/show/NCT00000736}) comparing
#' zidovudine (AZT) with a placebo in adults with asymptomatic HIV infection. The study results were described in
#' Volberding et al. (1990) <doi:10.1056/NEJM199004053221401>.
#'
#' @name actg019
#' @docType data
#' @usage actg019
#' @keywords data
#' @format A data frame with 822 rows and 5 variables:
#' \describe{
#'   \item{outcome}{outcome variable with 1 indicating death, development of AIDS or AIDS-related complex (ARC) and 0 otherwise}
#'   \item{age}{patient age in years}
#'   \item{treatment}{treatment indicator, 0 = placebo, 1 = AZT}
#'   \item{race}{race indicator, 0 = non-white, 1 = white}
#'   \item{cd4}{CD4 cell count}
#' }
#' @references
#'  Volberding, P. A., Lagakos, S. W., Koch, M. A., Pettinelli, C., Myers, M. W., Booth, D. K., Balfour, H. H., Reichman, R. C., Bartlett, J. A., Hirsch, M. S., Murphy, R. L., Hardy, W. D., Soeiro, R., Fischl, M. A., Bartlett, J. G., Merigan, T. C., Hyslop, N. E., Richman, D. D., Valentine, F. T., Corey, L., and the AIDS Clinical Trials Group of the National Institute of Allergy and Infectious Diseases (1990). Zidovudine in asymptomatic human immunodeficiency virus infection. New England Journal of Medicine, 322(14), 941–949.
#'
#'  Chen, M.-H., Ibrahim, J. G., and Yiannoutsos, C. (1999). Prior elicitation, Variable Selection and Bayesian computation for Logistic Regression Models. Journal of the Royal Statistical Society Series B: Statistical Methodology, 61(1), 223–242.
NULL
