% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_checks.R
\name{check_feature_na}
\alias{check_feature_na}
\title{Find features with (specified amount of) missingness}
\usage{
check_feature_na(data, threshold)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{threshold}{Missingness threshold in a given column/feature as a proportion bounded between 0 and 1. Default set to sensitive level at 1e-04.}
}
\value{
A vector of column/feature names that contain missingness greater than \code{threshold}.
}
\description{
Find features with (specified amount of) missingness
}
\examples{
\dontrun{
check_feature_na(data = any_data_frame, threshold = 1e-04)
}
}
