% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdis_mp.R
\name{hdis_mp}
\alias{hdis_mp}
\title{Discord discovery using Matrix Profile}
\usage{
hdis_mp(mode = "stamp", w, qtd)
}
\arguments{
\item{mode}{Character. Algorithm: one of "stomp", "stamp", "simple",
"mstomp", "scrimp", "valmod", "pmp".}

\item{w}{Integer. Subsequence window size.}

\item{qtd}{Integer. Number of discords to return (>= 3 recommended).}
}
\value{
\code{hdis_mp} object.
}
\description{
Discovers rare, dissimilar subsequences (discords) using Matrix Profile as
implemented in the \code{tsmp} package \url{doi:10.32614/RJ-2020-021}.
}
\examples{
library(daltoolbox)

# Load motif/discord example data
data(examples_motifs)

# Use a simple sequence example
dataset <- examples_motifs$simple
head(dataset)

# Configure discord discovery via Matrix Profile
model <- hdis_mp("stamp", 4, 3)

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected discords
print(detection[(detection$event),])

}
\references{
\itemize{
\item Yeh CCM, et al. (2016). Matrix Profile I/II: All-pairs similarity joins and scalable
time series motifs/discrod discovery. IEEE ICDM.
\item Tavenard R, et al. tsmp: The Matrix Profile in R. The R Journal (2020). doi:10.32614/RJ-2020-021
}
}
