% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_ensemble.R
\name{har_ensemble}
\alias{har_ensemble}
\title{Harbinger Ensemble}
\usage{
har_ensemble(...)
}
\arguments{
\item{...}{One or more detector objects.}
}
\value{
A \code{har_ensemble} object
}
\description{
Majority-vote ensemble across multiple Harbinger detectors with optional
temporal fuzzification to combine nearby detections.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure an ensemble of detectors
model <- har_ensemble(hanr_arima(), hanr_arima(), hanr_arima())
# model <- har_ensemble(hanr_fbiad(), hanr_arima(), hanr_emd())

# Fit all ensemble members
model <- fit(model, dataset$serie)

# Run ensemble detection
detection <- detect(model, dataset$serie)

# Show detected events
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
