% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd.R
\name{fd}
\alias{fd}
\title{Calculate fractal dimension}
\usage{
fd(data, method, lvec, keep_data = FALSE, diagnose = FALSE, ...)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer or a triangular mesh of class mesh3d.}

\item{method}{If data is a RasterLayer, possible methods are:"hvar", "area", "sd", and "cubes" (defaults to "hvar").
If data is a mesh3d, possible methods are "cubes" and "area" (defaults to "cubes").}

\item{lvec}{Vector of scales to use for calculation.}

\item{keep_data}{Logical. Keep data? Default is FALSE.}

\item{diagnose}{Logical. Show diagnostic plot and metrics?}

\item{...}{Arguments from method-specific fd_ functions.}
}
\value{
A value for fractal dimension, typically between 2 and 3 or a list if keep_data = TRUE.
}
\description{
Calculate fractal dimension
}
\details{
Calculates fractal dimension using the specified method.
Note that methods are distinctly different and should not be mixed when comparing values for multiple objects.
See \code{\link[=fd_hvar]{fd_hvar()}}, \code{\link[=fd_area]{fd_area()}}, \code{\link[=fd_cubes]{fd_cubes()}}, \code{\link[=fd_sd]{fd_sd()}} for details about each method.
If \code{lvec} is not specified, a default based on resolution, extent, and method will be used.
The \code{cubes} method is not recommended if the height range is much smaller than the extent of a 3d object or DEM, which is typically the case for DEMs.
Most objects and surfaces are not perfectly fractal. It is recommended to investigate scale transitions by setting diagnose to TRUE.
}
\examples{
\donttest{
dem <- dem_crop(horseshoe, x0 = -469, y0 = 1267, L = 2, plot = TRUE)
fd(dem, method = "hvar", lvec = c(0.125, 0.25, 0.5, 1, 2))
fd(dem, method = "area", diagnose = TRUE)
fd(dem, method = "sd")
fd(mcap2, method = "cubes",  plot = TRUE)
fd(mcap2, method = "area",  diagnose = TRUE)
}
}
\seealso{
\code{\link[=fd_hvar]{fd_hvar()}}

\code{\link[=fd_area]{fd_area()}}

\code{\link[=fd_sd]{fd_sd()}}

\code{\link[=fd_cubes]{fd_cubes()}}

\code{\link[=fd_diagnose]{fd_diagnose()}}
}
