% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_to_points.R
\name{dem_to_points}
\alias{dem_to_points}
\title{Transform DEM to 3D pointcloud of raster corners}
\usage{
dem_to_points(dem, bh = NULL, parallel = FALSE)
}
\arguments{
\item{dem}{Digital elevation model of class RasterLayer.}

\item{bh}{Border height from lowest point.}

\item{parallel}{Logical. Use parallel computation?}
}
\value{
A 3D point cloud for raster cell corners.
}
\description{
Transform DEM to 3D pointcloud of raster corners
}
\examples{
dem <- sim_dem(20, 0.5)
raster::plot(dem)
pts <- dem_to_points(dem)
rgl::plot3d(pts)


}
