% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_count.R
\name{cell_count_1d}
\alias{cell_count_1d}
\title{Count filled cells in 1D}
\usage{
cell_count_1d(pts, xmin, xmax, n)
}
\arguments{
\item{pts}{Data frame with x coordinates}

\item{xmin}{Minimum x-value}

\item{xmax}{Maximum x-value}

\item{n}{Multiplier}
}
\value{
Number of filled cells
}
\description{
A helper function for segment, box and cube counting fractal methods.
The function divide the array into \code{n} pieces and counts how many are
occupied.
}
\examples{
pts <- data.frame(x = rnorm(200, 0, 5))
cell_count_1d(pts, xmin = min(pts$x), xmax = max(pts$x), n = 5)


}
