% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.relevel_by_frequency}
\alias{h2o.relevel_by_frequency}
\title{Reorders levels of factor columns by the frequencies for the individual levels.}
\usage{
h2o.relevel_by_frequency(x, weights_column = NULL, top_n = -1)
}
\arguments{
\item{x}{H2O frame with some factor columns}

\item{weights_column}{optional name of weights column}

\item{top_n}{optional number of most frequent levels to move to the top (eg.: for top_n=1 move only the most frequent level)}
}
\value{
new reordered frame
}
\description{
The levels of a factor are reordered so that the most frequency level is at level 0, 
remaining levels are ordered from the second most frequent to the least frequent.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Convert iris dataset to an H2OFrame
iris_hf <- as.h2o(iris)
# Look at current ordering of the Species column levels
h2o.levels(iris_hf["Species"])
# "setosa"     "versicolor" "virginica" 
# Change the reference level to "virginica"
iris_hf["Species"] <- h2o.relevel_by_frequency(x = iris_hf["Species"])
# Observe new ordering
h2o.levels(iris_hf["Species"])
# "virginica"  "versicolor" "setosa"
}
}
