% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text_tbl_ae.R
\name{inline_text_tbl_ae}
\alias{inline_text_tbl_ae}
\alias{inline_text.tbl_ae}
\alias{inline_text.tbl_ae_count}
\alias{inline_text.tbl_ae_focus}
\title{Report Values from gtreg tables in-line}
\usage{
\method{inline_text}{tbl_ae}(x, row, column = NULL, ...)

\method{inline_text}{tbl_ae_count}(x, row, column = NULL, ...)

\method{inline_text}{tbl_ae_focus}(x, row, column = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{tbl_ae()}, \code{tbl_ae_count()}, \code{tbl_ae_focus()}}

\item{row}{string indicating the AE or SOC to report}

\item{column}{column name of cell to report. Use \code{show_header_names(x)}
to print all column names beside the current header.}

\item{...}{not used}
}
\value{
string
}
\description{
Function allows users to report formatted and styled results from
gtreg tables in-line.
}
\examples{
\donttest{
tbl <-
  df_adverse_events \%>\%
  tbl_ae(
    id = patient_id,
    ae = adverse_event,
    soc = system_organ_class,
    by = grade
  )
show_header_names(tbl)

inline_text(tbl, "Anaemia", column = stat_5)
}
}
