% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_field_exists}
\alias{check_field_exists}
\alias{assert_field_exists}
\title{Check the existence of fields in a GTFS object element}
\usage{
check_field_exists(x, file, fields)

assert_field_exists(x, file, fields)
}
\arguments{
\item{x}{A GTFS object.}

\item{file}{A string. The element, that represents a GTFS text file, where
fields should be searched.}

\item{fields}{A character vector. The fields to check the existence of.}
}
\value{
\code{check_field_exists} returns \code{TRUE} if the check is successful, and
\code{FALSE} otherwise. \cr
\code{assert_field_exists} returns \code{x} invisibly if the check is
successful, and throws an error otherwise.
}
\description{
Checks the existence of fields, represented by columns, inside a GTFS object
element.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

check_field_exists(gtfs, "calendar", c("monday", "tuesday"))

check_field_exists(gtfs, "calendar", c("monday", "oi"))

}
\seealso{
Other checking functions: 
\code{\link{check_field_class}()},
\code{\link{check_file_exists}()}
}
\concept{checking functions}
