% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_specvol_second_derivatives}
\alias{gsw_specvol_second_derivatives}
\title{Second Derivatives of Specific Volume}
\usage{
gsw_specvol_second_derivatives(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{specvol_SA_SA} [ (m^3/kg)/(g/kg)^2 ], the second derivative of
specific volume with respect to Absolute Salinity,
\code{specvol_SA_CT} [ (m^3/kg)/(g/kg)/degC ], the derivative of
specific volume with respect to Absolute Salinity and Conservative Temperature,
\code{specvol_CT_CT} [ (m^3/kg)/degC^2 ], the second derivative of
specific volume with respect to Conservative Temperature,
\code{specvol_SA_p} [ (m^3/kg)/(g/kg)/Pa ], the derivative of specific volume with respect to Absolute
Salinity and pressure, and \code{specvol_CT_p} [ (m^3/kg)/K/dbar ], the derivative of specific
volume with respect to Conservative Temperature and pressure.
}
\description{
Second Derivatives of Specific Volume
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)

r <- gsw_specvol_second_derivatives(SA, CT, p)

stopifnot(all.equal(r$specvol_SA_SA/1e-8, c(0.080906777599140,
            0.080915086639384, 0.084568844270812, 0.096725108896007,
            0.099111765836648, 0.100302277946072)))

stopifnot(all.equal(r$specvol_SA_CT/1e-8, c(0.129965332117084,
            0.130523053162130, 0.149555815430615, 0.217023290441810,
            0.233892039070486, 0.243659989480325)))

stopifnot(all.equal(r$specvol_CT_CT/1e-7, c(0.071409582006642,
            0.071582962051991, 0.077436153664104, 0.095329736274850,
            0.100105336953738, 0.103044572835472)))

stopifnot(all.equal(r$specvol_SA_p/1e-14, c(0.116889015000936,
            0.116897424150385, 0.121500614193893, 0.136008673596132,
            0.139023051292893, 0.140581903529772)))

stopifnot(all.equal(r$specvol_CT_p/1e-14, c(0.085542828707964,
            0.086723632576213, 0.112156562396990, 0.188269893599500,
            0.211615556759369, 0.228609575049911)))

}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_specvol_second_derivatives.html}
}
