% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_p_from_z}
\alias{gsw_p_from_z}
\title{Pressure from height (75-term equation)}
\usage{
gsw_p_from_z(z, latitude, geo_strf_dyn_height, sea_surface_geopotential)
}
\arguments{
\item{z}{height, zero at surface (but note last 2 args) and positive upwards [ m ]}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}

\item{geo_strf_dyn_height}{vector of same length as \code{z} and \code{latitude},
indicating dynamic height [ m^2/s^2 ].
If not supplied, this defaults to a vector of 0 values, with length matching that
of \code{z}.}

\item{sea_surface_geopotential}{vector of same length as \code{z} and \code{latitude},
indicating geopotential at zero sea pressure [ m^2/s^2 ].
If not supplied, this defaults to a vector of 0 values, with length matching that
of \code{z}.}
}
\value{
sea pressure [ dbar ]
}
\description{
Pressure from height (75-term equation)
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\section{Historical Note}{

The \code{geo_strf_dyn_height} and \code{sea_surface_geopotential}
parameters were added in GSW-R version 1.0-6.
}

\examples{
z <- -c(10, 50, 125, 250, 600, 1000)
latitude <- 4
p <- gsw_p_from_z(z, latitude)
stopifnot(all.equal(p/1e3, c(0.010055726724518, 0.050283543374874, 0.125731858435610,
                             0.251540299593468, 0.604210012340727, 1.007990337692001)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_p_from_z.html}
}
\seealso{
Other things related to depth: 
\code{\link{gsw_z_from_p}()}
}
\concept{things related to depth}
