% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_average.R
\name{cv_average}
\alias{cv_average}
\title{Average fit measures computed in the K-fold cross-validation procedure}
\usage{
cv_average(cv_array, fit_measure)
}
\arguments{
\item{cv_array}{\eqn{Q \times nthrs \times K} array containing fit measures computed for different combinations of the number of components, threshold values, and number of CV-folds.}

\item{fit_measure}{character vector of length 1 indicating the type of fit measure to be used in the to cross-validation procedure}
}
\value{
list of three \eqn{Q \times nthrs} matrices:
\itemize{
\item \code{scor}: contains the average CV scores across the K folds
\item \code{scor_upr}: contains the average CV scores across the K folds + 1 standard deviation
\item \code{scor_lwr}: contains the average CV scores across the K folds - 1 standard deviation
}
}
\description{
Function to average results from an array of K-fold CV fit measures.
}
\details{
The input of this function is an array of \eqn{Q \times nthrs \times K}, where \code{Q} is the number of principal components, \code{nthrs} is the number of thresholds, and \code{K} is the number of folds.
}
\examples{
# Example inputs
cv_array = array(abs(rnorm(10 * 3 * 2)), dim = c(10, 3, 2))
fit_measure = "F"

# Use the function
cv_average(cv_array, fit_measure)

}
\author{
Edoardo Costantini, 2023
}
