% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LL_gaussian.R
\name{LL_gaussian}
\alias{LL_gaussian}
\title{Gaussian log-likelihood}
\usage{
LL_gaussian(y, x, mod)
}
\arguments{
\item{y}{numeric vector recording a continuous dependent variable.}

\item{x}{data.frame (or matrix) containing predictor values.}

\item{mod}{\code{glm} or \code{lm} object containing the estimated linear regression model.}
}
\value{
A list containing:
\itemize{
\item \code{ll} an atomic vector of length 1 containing the log-likelihood value.
\item \code{sc} an atomic vector containing the systematic component for the input \code{x} and \code{mod}.
}
}
\description{
Computes the gaussian (normal) log-likelihood of a vector of observed values given a trained linear regression model.
}
\details{
If \code{x} and \code{y} are equal to the data on which \code{mod} has been trained, this function returns the same result as the default \code{logLink} function. If \code{x} and \code{y} are new, the function returns the log-likelihood of the new data under the trained model.
}
\author{
Edoardo Costantini, 2022
}
