% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsheet2text.R
\name{gsheet2text}
\alias{gsheet2text}
\title{Download Google sheet as text.}
\usage{
gsheet2text(url, format = "csv", sheetid = NULL)
}
\arguments{
\item{url}{the google sheet url}

\item{format}{controls the column separator used. \code{csv} or \code{tsv}}

\item{sheetid}{the id of the sheet to download from.  (Default \code{NULL}, downloads the first sheet)}
}
\description{
Downloads a Google sheet as text, using just the url.
The Google sheet must have 'share by link' turned on.
}
\details{
\code{sheetid} is the index of the sheet to be downloaded. 
If you use the direct sheet URL, rather than the share by link, this will automatically be extracted. 
Otherwise, the first sheet will be downloaded by default.
}
\examples{

url <- 'docs.google.com/spreadsheets/d/1I9mJsS5QnXF2TNNntTy-HrcdHmIF9wJ8ONYvEJTXSNo'
a <- gsheet2text(url)
b <- read.csv(text=a)

}
\seealso{
\code{\link{gsheet2text}} to download as a table
}
