% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xover.R
\name{xover}
\alias{xover}
\title{internal function to do crossovers and create recombinations}
\usage{
xover(V1, V2, R)
}
\arguments{
\item{V1}{integer vector of recombination points already existing on the
first incoming gamete.  Its names are the names of the
founder haplotype that the left end originates from (i.e. it is from the named
haplotype up until it changes at each point).  For example
c(A = 0, B = 12890, B = 30000) would work for a 30 Kb chromosome in which there
is a single recombination just to the right of the point 12890.
(In that example, positions 1 through 12890 are from founder haplotype A, while positions
12891 to 30000 are from founder haplotype B.) Note that these
vectors have to have a first
value of 0 and a final value of the chromosome length.}

\item{V2}{integer vector of breakpoints of the second incoming gamete.  Format
is just like it is for V1.}

\item{R}{a vector of new breakpoints to insert into the existing ones on each gamete.
This is usually returned from the function \code{recomb_point()}.}
}
\value{
This sends back two updated gametes, V1 and V2, but with the new points
of recombination stuck in there.  Note, for two incoming gametes there are two
outgoing gametes, but we aren't "re-using" any genomic sequence.
}
\description{
This function doesn't choose the recombination points.  That is done with
the function \code{recomb_point()},
and the results are passed into this function. The two inputs \code{V1} and
\code{V2} represent the two gametes coming into an individual on the pedigree.
Recombination occurs within that individual, and the two resulting gametes
from that recombination are the output.  Typically this is not the way
things happen, of course.  Generally, only one of the two resulting gametes
from the recombination will be segregated to a surviving offspring. But,
since we are interested in segregating genetic material without duplicating
or destroying any of it, we keep track of both gametes that result
from the meiosis/recombination.
}
\examples{
#' # make the two gametes/chromosomes coming into the function.
#' # Each one has length 30000 and a single existing recombination
V1 <- c(A = 0, B = 10000, B = 30000)
V2 <- c(C = 0, D = 20000, D = 30000)

# now, set a new recombination point at position 15000
xover(V1, V2, R = 15000)

# set three recombination points at 5,000, 15,000, and 25,000:
xover(V1, V2, R = c(5000, 15000, 25000))

# no recombinations (R is a zero length numeric vector)
xover(V1, V2, R = numeric(0))
}
