% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_simulated_chromosome_segments.R
\name{plot_simulated_chromomsome_segments}
\alias{plot_simulated_chromomsome_segments}
\title{Plot the simulated chromosomes of an individual}
\usage{
plot_simulated_chromomsome_segments(
  Segs,
  RR = NULL,
  fill_by_group_origin = FALSE,
  rel_heights = c(chrom_ht = 4, chrom_gap = 0.8, spark_gap = 0.2 * !is.null(RR),
    spark_box = 2.6 * !is.null(RR), unit_gap = 4),
  bottom_gap = 0.3,
  spark_thick = 0.2,
  spark_splat = 0.25
)
}
\arguments{
\item{Segs}{a tibble of segments}

\item{RR}{a tibble of recombination rates in bins in the format
of \link{RecRates}. If this is
included, the recombination rates in cM/Mb are plotted atop the chromosomes
as a little sparkline. If it is not included, then the there are
no little sparklines above the chromosomes.}

\item{fill_by_group_origin}{If FALSE (the default) the fill color of segments
is mapped to the pop_origin, which is where the founder haplotypes came from according
to the \code{hpop1} and \code{hpop2} columns in the GSP specification. If you set this
to TRUE, then we map the "group" column of the reppop to fill.}

\item{rel_heights}{a vector the the relative heights of the different
elements of each chromosomal unit of the plot.  This is a named vector
with the following elements, listed in order of the bottom of each
unit to the top:
\itemize{
\item \code{chrom_ht}: the height of the bars for each of the two chromosomes of the
pair in a chromosome unit.
\item \code{chrom_gap}: The gap between the two homologous chromosomes of the individual.
\item \code{spark_gap}: the gap between the top chromosome and the sparkline box
for recombination rates.
\item \code{spark_box}: height of the box within which the sparkline goes.  Note that
the sparkline itself will be scaled so that the highest rate anywhere within
the genome will correspond to the top of the spark box.
\item \code{unit_gap}: The relative height of the gap between one chromosome unit and
the next.
}}

\item{bottom_gap}{the y value of the bottom chromosome unit.  Basically the
absolute distance between the y=0 line and the start of the plotted material.
Should typically be between 0 and 1.}

\item{spark_thick}{thickness of the line that draws the recombination rate
sparkline.}

\item{spark_splat}{fraction by which the unit gap should be reduced when
there are sparklines being drawn.}
}
\value{
This function returns a ggplot object.  Each facet of the plot shows
the chromosomes of a different sampled individual from a particular replicate
simulation from a particular genome simulation pedigree.  The facets are titled
like: \verb{GSP 1, Idx 2, ID 8[3]}, which means that the chromosomes shown in the panel
are from the third sampled set of chromosomes from the individual with ID 8 from the
simulation from genome simulation pedigree 1 with index 2.
}
\description{
This function uses the information in the tibble about segments
dropped down a genome simulation pedigree to plot the
chromomomes of an individual colored by
the population of origin of each segment.
}
\examples{
s <- example_segments
rr <- RecRates
g <- plot_simulated_chromomsome_segments(s)
g_with_sparklines <- plot_simulated_chromomsome_segments(s, rr)
}
