% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{powerplot}
\alias{powerplot}
\title{Plot the power function of the planned analysis}
\usage{
powerplot(
  x,
  ref = FALSE,
  add = FALSE,
  lty = 1,
  ref.lty = 2,
  lwd = 1,
  xlab = expression(delta),
  ylab = "Power",
  main = "Power curve of the planned futility analysis",
  xlim = c(0, 1.5),
  ylim = c(0, 1),
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{fut}}.}

\item{ref}{If TRUE, power curve of the reference test (one that ignores the futility boundaries)
will be overlaid.}

\item{add}{If TRUE, the curve will be overlaid on an existing plot; otherwise,
a separate plot will be constructed.}

\item{lty}{Line type for the power curve of the futility analysis.}

\item{ref.lty}{Line type for the power curve of the reference if \code{ref=TRUE}.}

\item{lwd}{Line width.}

\item{xlab}{A label for the x axis, defaults to a description of x.}

\item{ylab}{A label for the y axis, defaults to a description of y.}

\item{main}{A main title for the plot.}

\item{xlim}{The x limits of the plot.}

\item{ylim}{The y limits of the plot.}

\item{...}{Other arguments that can be passed to the underlying \code{plot} method.}
}
\value{
No return value, called for side effects.
}
\description{
Plot the power curve of the planned futility analysis as a function of
the effect size (in units of the hypothesized effect size).
}
\examples{
# see example for fut
}
\seealso{
\code{\link{fut}}, \code{\link{summary.fut}}, \code{\link{plot.fut}}.
}
\keyword{fut}
